<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Project extends Model 
{

    protected $table = 'projects';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function partners()
    {
        return $this->belongsToMany('App\Models\Partner', 'project_partner', 'project_id', 'partner_id');
    }

    public function keywords()
    {
        return $this->belongsToMany('App\Models\Keyword', 'project_keyword', 'project_id', 'keyword_id');
    }

    public function milestones()
    {
        return $this->hasMany('App\Models\Milestone', 'project_id');
    }

    public function payments()
    {
        return $this->hasMany('App\Models\Payment', 'project_id');
    }

    public function modifies()
    {
        return $this->hasMany('App\Models\Modify', 'project_id');
    }

    public function monitorings()
    {
        return $this->hasMany('App\Models\Monitoring', 'project_id');
    }

    public function procurements()
    {
        return $this->hasMany('App\Models\Procurement', 'project_id');
    }

    public function statements()
    {
        return $this->hasMany('App\Models\Statement', 'project_id');
    }

    public function financings()
    {
        return $this->belongsToMany('App\Models\Financing', 'project_financing', 'project_id', 'financing_id', '');
    }

    public function events()
    {
        return $this->hasMany('App\Models\Event', 'project_id');
    }

}